// Copyright 2023, OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file includes work covered by the following copyright and permission notices:
//
// Copyright 2016 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Profile is a common stacktrace profile format.
//
// Measurements represented with this format should follow the
// following conventions:
//
// - Consumers should treat unset optional fields as if they had been
//   set with their default value.
//
// - When possible, measurements should be stored in "unsampled" form
//   that is most useful to humans.  There should be enough
//   information present to determine the original sampled values.
//
// - On-disk, the serialized proto must be gzip-compressed.
//
// - The profile is represented as a set of samples, where each sample
//   references a sequence of locations, and where each location belongs
//   to a mapping.
// - There is a N->1 relationship from sample.location_id entries to
//   locations. For every sample.location_id entry there must be a
//   unique Location with that index.
// - There is an optional N->1 relationship from locations to
//   mappings. For every nonzero Location.mapping_id there must be a
//   unique Mapping with that index.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.6
// source: opentelemetry/proto/profiles/v1experimental/pprofextended.proto

package v1experimental

import (
	v1 "go.opentelemetry.io/proto/slim/otlp/common/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the method of aggregating metric values, either DELTA (change since last report)
// or CUMULATIVE (total since a fixed start time).
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	//* DELTA is an AggregationTemporality for a profiler which reports
	//changes since last report time. Successive metrics contain aggregation of
	//values from continuous and non-overlapping intervals.
	//
	//The values for a DELTA metric are based only on the time interval
	//associated with one measurement cycle. There is no dependency on
	//previous measurements like is the case for CUMULATIVE metrics.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//DELTA metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0+1 to
	//t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	//* CUMULATIVE is an AggregationTemporality for a profiler which
	//reports changes since a fixed start time. This means that current values
	//of a CUMULATIVE metric depend on all previous measurements since the
	//start time. Because of this, the sender is required to retain this state
	//in some form. If this state is lost or invalidated, the CUMULATIVE metric
	//values MUST be reset and a new fixed start time following the last
	//reported measurement time sent MUST be used.
	//
	//For example, consider a system measuring the number of requests that
	//it receives and reports the sum of these requests every second as a
	//CUMULATIVE metric:
	//
	//1. The system starts receiving at time=t_0.
	//2. A request is received, the system measures 1 request.
	//3. A request is received, the system measures 1 request.
	//4. A request is received, the system measures 1 request.
	//5. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+1 with a value of 3.
	//6. A request is received, the system measures 1 request.
	//7. A request is received, the system measures 1 request.
	//8. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_0 to
	//t_0+2 with a value of 5.
	//9. The system experiences a fault and loses state.
	//10. The system recovers and resumes receiving at time=t_1.
	//11. A request is received, the system measures 1 request.
	//12. The 1 second collection cycle ends. A metric is exported for the
	//number of requests received over the interval of time t_1 to
	//t_0+1 with a value of 1.
	//
	//Note: Even though, when reporting changes since last report time, using
	//CUMULATIVE is valid, it is not recommended.
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

// Enum value maps for AggregationTemporality.
var (
	AggregationTemporality_name = map[int32]string{
		0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
		1: "AGGREGATION_TEMPORALITY_DELTA",
		2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
	}
	AggregationTemporality_value = map[string]int32{
		"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
		"AGGREGATION_TEMPORALITY_DELTA":       1,
		"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
	}
)

func (x AggregationTemporality) Enum() *AggregationTemporality {
	p := new(AggregationTemporality)
	*p = x
	return p
}

func (x AggregationTemporality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregationTemporality) Descriptor() protoreflect.EnumDescriptor {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes[0].Descriptor()
}

func (AggregationTemporality) Type() protoreflect.EnumType {
	return &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes[0]
}

func (x AggregationTemporality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregationTemporality.Descriptor instead.
func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{0}
}

// Indicates the semantics of the build_id field.
type BuildIdKind int32

const (
	// Linker-generated build ID, stored in the ELF binary notes.
	BuildIdKind_BUILD_ID_LINKER BuildIdKind = 0
	// Build ID based on the content hash of the binary. Currently no particular
	// hashing approach is standardized, so a given producer needs to define it
	// themselves and thus unlike BUILD_ID_LINKER this kind of hash is producer-specific.
	// We may choose to provide a standardized stable hash recommendation later.
	BuildIdKind_BUILD_ID_BINARY_HASH BuildIdKind = 1
)

// Enum value maps for BuildIdKind.
var (
	BuildIdKind_name = map[int32]string{
		0: "BUILD_ID_LINKER",
		1: "BUILD_ID_BINARY_HASH",
	}
	BuildIdKind_value = map[string]int32{
		"BUILD_ID_LINKER":      0,
		"BUILD_ID_BINARY_HASH": 1,
	}
)

func (x BuildIdKind) Enum() *BuildIdKind {
	p := new(BuildIdKind)
	*p = x
	return p
}

func (x BuildIdKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildIdKind) Descriptor() protoreflect.EnumDescriptor {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes[1].Descriptor()
}

func (BuildIdKind) Type() protoreflect.EnumType {
	return &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes[1]
}

func (x BuildIdKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildIdKind.Descriptor instead.
func (BuildIdKind) EnumDescriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{1}
}

// Represents a complete profile, including sample types, samples,
// mappings to binaries, locations, functions, string table, and additional metadata.
type Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the samples associated with each Sample.value.
	// For a cpu profile this might be:
	//   [["cpu","nanoseconds"]] or [["wall","seconds"]] or [["syscall","count"]]
	// For a heap profile, this might be:
	//   [["allocations","count"], ["space","bytes"]],
	// If one of the values represents the number of events represented
	// by the sample, by convention it should be at index 0 and use
	// sample_type.unit == "count".
	SampleType []*ValueType `protobuf:"bytes,1,rep,name=sample_type,json=sampleType,proto3" json:"sample_type,omitempty"`
	// The set of samples recorded in this profile.
	Sample []*Sample `protobuf:"bytes,2,rep,name=sample,proto3" json:"sample,omitempty"`
	// Mapping from address ranges to the image/binary/library mapped
	// into that address range.  mapping[0] will be the main binary.
	Mapping []*Mapping `protobuf:"bytes,3,rep,name=mapping,proto3" json:"mapping,omitempty"`
	// Locations referenced by samples via location_indices.
	Location []*Location `protobuf:"bytes,4,rep,name=location,proto3" json:"location,omitempty"`
	// Array of locations referenced by samples.
	LocationIndices []int64 `protobuf:"varint,15,rep,packed,name=location_indices,json=locationIndices,proto3" json:"location_indices,omitempty"`
	// Functions referenced by locations.
	Function []*Function `protobuf:"bytes,5,rep,name=function,proto3" json:"function,omitempty"`
	// Lookup table for attributes.
	AttributeTable []*v1.KeyValue `protobuf:"bytes,16,rep,name=attribute_table,json=attributeTable,proto3" json:"attribute_table,omitempty"`
	// Represents a mapping between Attribute Keys and Units.
	AttributeUnits []*AttributeUnit `protobuf:"bytes,17,rep,name=attribute_units,json=attributeUnits,proto3" json:"attribute_units,omitempty"`
	// Lookup table for links.
	LinkTable []*Link `protobuf:"bytes,18,rep,name=link_table,json=linkTable,proto3" json:"link_table,omitempty"`
	// A common table for strings referenced by various messages.
	// string_table[0] must always be "".
	StringTable []string `protobuf:"bytes,6,rep,name=string_table,json=stringTable,proto3" json:"string_table,omitempty"`
	// frames with Function.function_name fully matching the following
	// regexp will be dropped from the samples, along with their successors.
	DropFrames int64 `protobuf:"varint,7,opt,name=drop_frames,json=dropFrames,proto3" json:"drop_frames,omitempty"` // Index into string table.
	// frames with Function.function_name fully matching the following
	// regexp will be kept, even if it matches drop_frames.
	KeepFrames int64 `protobuf:"varint,8,opt,name=keep_frames,json=keepFrames,proto3" json:"keep_frames,omitempty"` // Index into string table.
	// Time of collection (UTC) represented as nanoseconds past the epoch.
	TimeNanos int64 `protobuf:"varint,9,opt,name=time_nanos,json=timeNanos,proto3" json:"time_nanos,omitempty"`
	// Duration of the profile, if a duration makes sense.
	DurationNanos int64 `protobuf:"varint,10,opt,name=duration_nanos,json=durationNanos,proto3" json:"duration_nanos,omitempty"`
	// The kind of events between sampled occurrences.
	// e.g [ "cpu","cycles" ] or [ "heap","bytes" ]
	PeriodType *ValueType `protobuf:"bytes,11,opt,name=period_type,json=periodType,proto3" json:"period_type,omitempty"`
	// The number of events between sampled occurrences.
	Period int64 `protobuf:"varint,12,opt,name=period,proto3" json:"period,omitempty"`
	// Free-form text associated with the profile. The text is displayed as is
	// to the user by the tools that read profiles (e.g. by pprof). This field
	// should not be used to store any machine-readable information, it is only
	// for human-friendly content. The profile must stay functional if this field
	// is cleaned.
	Comment []int64 `protobuf:"varint,13,rep,packed,name=comment,proto3" json:"comment,omitempty"` // Indices into string table.
	// Index into the string table of the type of the preferred sample
	// value. If unset, clients should default to the last sample value.
	DefaultSampleType int64 `protobuf:"varint,14,opt,name=default_sample_type,json=defaultSampleType,proto3" json:"default_sample_type,omitempty"`
}

func (x *Profile) Reset() {
	*x = Profile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Profile) ProtoMessage() {}

func (x *Profile) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Profile.ProtoReflect.Descriptor instead.
func (*Profile) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{0}
}

func (x *Profile) GetSampleType() []*ValueType {
	if x != nil {
		return x.SampleType
	}
	return nil
}

func (x *Profile) GetSample() []*Sample {
	if x != nil {
		return x.Sample
	}
	return nil
}

func (x *Profile) GetMapping() []*Mapping {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *Profile) GetLocation() []*Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Profile) GetLocationIndices() []int64 {
	if x != nil {
		return x.LocationIndices
	}
	return nil
}

func (x *Profile) GetFunction() []*Function {
	if x != nil {
		return x.Function
	}
	return nil
}

func (x *Profile) GetAttributeTable() []*v1.KeyValue {
	if x != nil {
		return x.AttributeTable
	}
	return nil
}

func (x *Profile) GetAttributeUnits() []*AttributeUnit {
	if x != nil {
		return x.AttributeUnits
	}
	return nil
}

func (x *Profile) GetLinkTable() []*Link {
	if x != nil {
		return x.LinkTable
	}
	return nil
}

func (x *Profile) GetStringTable() []string {
	if x != nil {
		return x.StringTable
	}
	return nil
}

func (x *Profile) GetDropFrames() int64 {
	if x != nil {
		return x.DropFrames
	}
	return 0
}

func (x *Profile) GetKeepFrames() int64 {
	if x != nil {
		return x.KeepFrames
	}
	return 0
}

func (x *Profile) GetTimeNanos() int64 {
	if x != nil {
		return x.TimeNanos
	}
	return 0
}

func (x *Profile) GetDurationNanos() int64 {
	if x != nil {
		return x.DurationNanos
	}
	return 0
}

func (x *Profile) GetPeriodType() *ValueType {
	if x != nil {
		return x.PeriodType
	}
	return nil
}

func (x *Profile) GetPeriod() int64 {
	if x != nil {
		return x.Period
	}
	return 0
}

func (x *Profile) GetComment() []int64 {
	if x != nil {
		return x.Comment
	}
	return nil
}

func (x *Profile) GetDefaultSampleType() int64 {
	if x != nil {
		return x.DefaultSampleType
	}
	return 0
}

// Represents a mapping between Attribute Keys and Units.
type AttributeUnit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index into string table.
	AttributeKey int64 `protobuf:"varint,1,opt,name=attribute_key,json=attributeKey,proto3" json:"attribute_key,omitempty"`
	// Index into string table.
	Unit int64 `protobuf:"varint,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *AttributeUnit) Reset() {
	*x = AttributeUnit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeUnit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeUnit) ProtoMessage() {}

func (x *AttributeUnit) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeUnit.ProtoReflect.Descriptor instead.
func (*AttributeUnit) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{1}
}

func (x *AttributeUnit) GetAttributeKey() int64 {
	if x != nil {
		return x.AttributeKey
	}
	return 0
}

func (x *AttributeUnit) GetUnit() int64 {
	if x != nil {
		return x.Unit
	}
	return 0
}

// A pointer from a profile Sample to a trace Span.
// Connects a profile sample to a trace span, identified by unique trace and span IDs.
type Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier of a trace that this linked span is part of. The ID is a
	// 16-byte array.
	TraceId []byte `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// A unique identifier for the linked span. The ID is an 8-byte array.
	SpanId []byte `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
}

func (x *Link) Reset() {
	*x = Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Link) ProtoMessage() {}

func (x *Link) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Link.ProtoReflect.Descriptor instead.
func (*Link) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{2}
}

func (x *Link) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

func (x *Link) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

// ValueType describes the type and units of a value, with an optional aggregation temporality.
type ValueType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                   int64                  `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"` // Index into string table.
	Unit                   int64                  `protobuf:"varint,2,opt,name=unit,proto3" json:"unit,omitempty"` // Index into string table.
	AggregationTemporality AggregationTemporality `protobuf:"varint,3,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.profiles.v1experimental.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (x *ValueType) Reset() {
	*x = ValueType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueType) ProtoMessage() {}

func (x *ValueType) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueType.ProtoReflect.Descriptor instead.
func (*ValueType) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{3}
}

func (x *ValueType) GetType() int64 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *ValueType) GetUnit() int64 {
	if x != nil {
		return x.Unit
	}
	return 0
}

func (x *ValueType) GetAggregationTemporality() AggregationTemporality {
	if x != nil {
		return x.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Each Sample records values encountered in some program
// context. The program context is typically a stack trace, perhaps
// augmented with auxiliary information like the thread-id, some
// indicator of a higher level request being handled etc.
type Sample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The indices recorded here correspond to locations in Profile.location.
	// The leaf is at location_index[0]. [deprecated, superseded by locations_start_index / locations_length]
	LocationIndex []uint64 `protobuf:"varint,1,rep,packed,name=location_index,json=locationIndex,proto3" json:"location_index,omitempty"`
	// locations_start_index along with locations_length refers to to a slice of locations in Profile.location.
	// Supersedes location_index.
	LocationsStartIndex uint64 `protobuf:"varint,7,opt,name=locations_start_index,json=locationsStartIndex,proto3" json:"locations_start_index,omitempty"`
	// locations_length along with locations_start_index refers to a slice of locations in Profile.location.
	// Supersedes location_index.
	LocationsLength uint64 `protobuf:"varint,8,opt,name=locations_length,json=locationsLength,proto3" json:"locations_length,omitempty"`
	// A 128bit id that uniquely identifies this stacktrace, globally. Index into string table. [optional]
	StacktraceIdIndex uint32 `protobuf:"varint,9,opt,name=stacktrace_id_index,json=stacktraceIdIndex,proto3" json:"stacktrace_id_index,omitempty"`
	// The type and unit of each value is defined by the corresponding
	// entry in Profile.sample_type. All samples must have the same
	// number of values, the same as the length of Profile.sample_type.
	// When aggregating multiple samples into a single sample, the
	// result has a list of values that is the element-wise sum of the
	// lists of the originals.
	Value []int64 `protobuf:"varint,2,rep,packed,name=value,proto3" json:"value,omitempty"`
	// label includes additional context for this sample. It can include
	// things like a thread id, allocation size, etc.
	//
	// NOTE: While possible, having multiple values for the same label key is
	// strongly discouraged and should never be used. Most tools (e.g. pprof) do
	// not have good (or any) support for multi-value labels. And an even more
	// discouraged case is having a string label and a numeric label of the same
	// name on a sample.  Again, possible to express, but should not be used.
	// [deprecated, superseded by attributes]
	Label []*Label `protobuf:"bytes,3,rep,name=label,proto3" json:"label,omitempty"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,10,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
	// Reference to link in Profile.link_table. [optional]
	Link uint64 `protobuf:"varint,12,opt,name=link,proto3" json:"link,omitempty"`
	// Timestamps associated with Sample represented in nanoseconds. These timestamps are expected
	// to fall within the Profile's time range. [optional]
	TimestampsUnixNano []uint64 `protobuf:"varint,13,rep,packed,name=timestamps_unix_nano,json=timestampsUnixNano,proto3" json:"timestamps_unix_nano,omitempty"`
}

func (x *Sample) Reset() {
	*x = Sample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sample) ProtoMessage() {}

func (x *Sample) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sample.ProtoReflect.Descriptor instead.
func (*Sample) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{4}
}

func (x *Sample) GetLocationIndex() []uint64 {
	if x != nil {
		return x.LocationIndex
	}
	return nil
}

func (x *Sample) GetLocationsStartIndex() uint64 {
	if x != nil {
		return x.LocationsStartIndex
	}
	return 0
}

func (x *Sample) GetLocationsLength() uint64 {
	if x != nil {
		return x.LocationsLength
	}
	return 0
}

func (x *Sample) GetStacktraceIdIndex() uint32 {
	if x != nil {
		return x.StacktraceIdIndex
	}
	return 0
}

func (x *Sample) GetValue() []int64 {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Sample) GetLabel() []*Label {
	if x != nil {
		return x.Label
	}
	return nil
}

func (x *Sample) GetAttributes() []uint64 {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Sample) GetLink() uint64 {
	if x != nil {
		return x.Link
	}
	return 0
}

func (x *Sample) GetTimestampsUnixNano() []uint64 {
	if x != nil {
		return x.TimestampsUnixNano
	}
	return nil
}

// Provides additional context for a sample,
// such as thread ID or allocation size, with optional units. [deprecated]
type Label struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key int64 `protobuf:"varint,1,opt,name=key,proto3" json:"key,omitempty"` // Index into string table
	// At most one of the following must be present
	Str int64 `protobuf:"varint,2,opt,name=str,proto3" json:"str,omitempty"` // Index into string table
	Num int64 `protobuf:"varint,3,opt,name=num,proto3" json:"num,omitempty"`
	// Should only be present when num is present.
	// Specifies the units of num.
	// Use arbitrary string (for example, "requests") as a custom count unit.
	// If no unit is specified, consumer may apply heuristic to deduce the unit.
	// Consumers may also  interpret units like "bytes" and "kilobytes" as memory
	// units and units like "seconds" and "nanoseconds" as time units,
	// and apply appropriate unit conversions to these.
	NumUnit int64 `protobuf:"varint,4,opt,name=num_unit,json=numUnit,proto3" json:"num_unit,omitempty"` // Index into string table
}

func (x *Label) Reset() {
	*x = Label{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Label.ProtoReflect.Descriptor instead.
func (*Label) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{5}
}

func (x *Label) GetKey() int64 {
	if x != nil {
		return x.Key
	}
	return 0
}

func (x *Label) GetStr() int64 {
	if x != nil {
		return x.Str
	}
	return 0
}

func (x *Label) GetNum() int64 {
	if x != nil {
		return x.Num
	}
	return 0
}

func (x *Label) GetNumUnit() int64 {
	if x != nil {
		return x.NumUnit
	}
	return 0
}

// Describes the mapping of a binary in memory, including its address range,
// file offset, and metadata like build ID
type Mapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique nonzero id for the mapping. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Address at which the binary (or DLL) is loaded into memory.
	MemoryStart uint64 `protobuf:"varint,2,opt,name=memory_start,json=memoryStart,proto3" json:"memory_start,omitempty"`
	// The limit of the address range occupied by this mapping.
	MemoryLimit uint64 `protobuf:"varint,3,opt,name=memory_limit,json=memoryLimit,proto3" json:"memory_limit,omitempty"`
	// Offset in the binary that corresponds to the first mapped address.
	FileOffset uint64 `protobuf:"varint,4,opt,name=file_offset,json=fileOffset,proto3" json:"file_offset,omitempty"`
	// The object this entry is loaded from.  This can be a filename on
	// disk for the main binary and shared libraries, or virtual
	// abstractions like "[vdso]".
	Filename int64 `protobuf:"varint,5,opt,name=filename,proto3" json:"filename,omitempty"` // Index into string table
	// A string that uniquely identifies a particular program version
	// with high probability. E.g., for binaries generated by GNU tools,
	// it could be the contents of the .note.gnu.build-id field.
	BuildId int64 `protobuf:"varint,6,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"` // Index into string table
	// Specifies the kind of build id. See BuildIdKind enum for more details [optional]
	BuildIdKind BuildIdKind `protobuf:"varint,11,opt,name=build_id_kind,json=buildIdKind,proto3,enum=opentelemetry.proto.profiles.v1experimental.BuildIdKind" json:"build_id_kind,omitempty"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,12,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
	// The following fields indicate the resolution of symbolic info.
	HasFunctions    bool `protobuf:"varint,7,opt,name=has_functions,json=hasFunctions,proto3" json:"has_functions,omitempty"`
	HasFilenames    bool `protobuf:"varint,8,opt,name=has_filenames,json=hasFilenames,proto3" json:"has_filenames,omitempty"`
	HasLineNumbers  bool `protobuf:"varint,9,opt,name=has_line_numbers,json=hasLineNumbers,proto3" json:"has_line_numbers,omitempty"`
	HasInlineFrames bool `protobuf:"varint,10,opt,name=has_inline_frames,json=hasInlineFrames,proto3" json:"has_inline_frames,omitempty"`
}

func (x *Mapping) Reset() {
	*x = Mapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mapping) ProtoMessage() {}

func (x *Mapping) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mapping.ProtoReflect.Descriptor instead.
func (*Mapping) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{6}
}

func (x *Mapping) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Mapping) GetMemoryStart() uint64 {
	if x != nil {
		return x.MemoryStart
	}
	return 0
}

func (x *Mapping) GetMemoryLimit() uint64 {
	if x != nil {
		return x.MemoryLimit
	}
	return 0
}

func (x *Mapping) GetFileOffset() uint64 {
	if x != nil {
		return x.FileOffset
	}
	return 0
}

func (x *Mapping) GetFilename() int64 {
	if x != nil {
		return x.Filename
	}
	return 0
}

func (x *Mapping) GetBuildId() int64 {
	if x != nil {
		return x.BuildId
	}
	return 0
}

func (x *Mapping) GetBuildIdKind() BuildIdKind {
	if x != nil {
		return x.BuildIdKind
	}
	return BuildIdKind_BUILD_ID_LINKER
}

func (x *Mapping) GetAttributes() []uint64 {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Mapping) GetHasFunctions() bool {
	if x != nil {
		return x.HasFunctions
	}
	return false
}

func (x *Mapping) GetHasFilenames() bool {
	if x != nil {
		return x.HasFilenames
	}
	return false
}

func (x *Mapping) GetHasLineNumbers() bool {
	if x != nil {
		return x.HasLineNumbers
	}
	return false
}

func (x *Mapping) GetHasInlineFrames() bool {
	if x != nil {
		return x.HasInlineFrames
	}
	return false
}

// Describes function and line table debug information.
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique nonzero id for the location.  A profile could use
	// instruction addresses or any integer sequence as ids. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The index of the corresponding profile.Mapping for this location.
	// It can be unset if the mapping is unknown or not applicable for
	// this profile type.
	MappingIndex uint64 `protobuf:"varint,2,opt,name=mapping_index,json=mappingIndex,proto3" json:"mapping_index,omitempty"`
	// The instruction address for this location, if available.  It
	// should be within [Mapping.memory_start...Mapping.memory_limit]
	// for the corresponding mapping. A non-leaf address may be in the
	// middle of a call instruction. It is up to display tools to find
	// the beginning of the instruction if necessary.
	Address uint64 `protobuf:"varint,3,opt,name=address,proto3" json:"address,omitempty"`
	// Multiple line indicates this location has inlined functions,
	// where the last entry represents the caller into which the
	// preceding entries were inlined.
	//
	// E.g., if memcpy() is inlined into printf:
	//    line[0].function_name == "memcpy"
	//    line[1].function_name == "printf"
	Line []*Line `protobuf:"bytes,4,rep,name=line,proto3" json:"line,omitempty"`
	// Provides an indication that multiple symbols map to this location's
	// address, for example due to identical code folding by the linker. In that
	// case the line information above represents one of the multiple
	// symbols. This field must be recomputed when the symbolization state of the
	// profile changes.
	IsFolded bool `protobuf:"varint,5,opt,name=is_folded,json=isFolded,proto3" json:"is_folded,omitempty"`
	// Type of frame (e.g. kernel, native, python, hotspot, php). Index into string table.
	TypeIndex uint32 `protobuf:"varint,6,opt,name=type_index,json=typeIndex,proto3" json:"type_index,omitempty"`
	// References to attributes in Profile.attribute_table. [optional]
	Attributes []uint64 `protobuf:"varint,7,rep,packed,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{7}
}

func (x *Location) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Location) GetMappingIndex() uint64 {
	if x != nil {
		return x.MappingIndex
	}
	return 0
}

func (x *Location) GetAddress() uint64 {
	if x != nil {
		return x.Address
	}
	return 0
}

func (x *Location) GetLine() []*Line {
	if x != nil {
		return x.Line
	}
	return nil
}

func (x *Location) GetIsFolded() bool {
	if x != nil {
		return x.IsFolded
	}
	return false
}

func (x *Location) GetTypeIndex() uint32 {
	if x != nil {
		return x.TypeIndex
	}
	return 0
}

func (x *Location) GetAttributes() []uint64 {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Details a specific line in a source code, linked to a function.
type Line struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index of the corresponding profile.Function for this line.
	FunctionIndex uint64 `protobuf:"varint,1,opt,name=function_index,json=functionIndex,proto3" json:"function_index,omitempty"`
	// Line number in source code.
	Line int64 `protobuf:"varint,2,opt,name=line,proto3" json:"line,omitempty"`
	// Column number in source code.
	Column int64 `protobuf:"varint,3,opt,name=column,proto3" json:"column,omitempty"`
}

func (x *Line) Reset() {
	*x = Line{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Line) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Line) ProtoMessage() {}

func (x *Line) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Line.ProtoReflect.Descriptor instead.
func (*Line) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{8}
}

func (x *Line) GetFunctionIndex() uint64 {
	if x != nil {
		return x.FunctionIndex
	}
	return 0
}

func (x *Line) GetLine() int64 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *Line) GetColumn() int64 {
	if x != nil {
		return x.Column
	}
	return 0
}

// Describes a function, including its human-readable name, system name,
// source file, and starting line number in the source.
type Function struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique nonzero id for the function. [deprecated]
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the function, in human-readable form if available.
	Name int64 `protobuf:"varint,2,opt,name=name,proto3" json:"name,omitempty"` // Index into string table
	// Name of the function, as identified by the system.
	// For instance, it can be a C++ mangled name.
	SystemName int64 `protobuf:"varint,3,opt,name=system_name,json=systemName,proto3" json:"system_name,omitempty"` // Index into string table
	// Source file containing the function.
	Filename int64 `protobuf:"varint,4,opt,name=filename,proto3" json:"filename,omitempty"` // Index into string table
	// Line number in source file.
	StartLine int64 `protobuf:"varint,5,opt,name=start_line,json=startLine,proto3" json:"start_line,omitempty"`
}

func (x *Function) Reset() {
	*x = Function{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP(), []int{9}
}

func (x *Function) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Function) GetName() int64 {
	if x != nil {
		return x.Name
	}
	return 0
}

func (x *Function) GetSystemName() int64 {
	if x != nil {
		return x.SystemName
	}
	return 0
}

func (x *Function) GetFilename() int64 {
	if x != nil {
		return x.Filename
	}
	return 0
}

func (x *Function) GetStartLine() int64 {
	if x != nil {
		return x.StartLine
	}
	return 0
}

var File_opentelemetry_proto_profiles_v1experimental_pprofextended_proto protoreflect.FileDescriptor

var file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2f, 0x70, 0x70,
	0x72, 0x6f, 0x66, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x2b, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x1a, 0x2a,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x08, 0x0a, 0x07, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x4b, 0x0a, 0x06, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x52, 0x06, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x4e, 0x0a, 0x07,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x51, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a,
	0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x63, 0x0a, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x75, 0x6e, 0x69,
	0x74, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x55, 0x6e, 0x69, 0x74, 0x52, 0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x55,
	0x6e, 0x69, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x6c, 0x69, 0x6e,
	0x6b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x72, 0x6f,
	0x70, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x64, 0x72, 0x6f, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6b, 0x65,
	0x65, 0x70, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x6b, 0x65, 0x65, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x4e, 0x61, 0x6e, 0x6f, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x73, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0d, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6e, 0x6f,
	0x73, 0x12, 0x57, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x48, 0x0a, 0x0d,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0x3a, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x19,
	0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e,
	0x49, 0x64, 0x22, 0xb1, 0x01, 0x0a, 0x09, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x7c, 0x0a, 0x17, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x16,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x84, 0x03, 0x0a, 0x06, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x03, 0x28, 0x04, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x10,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x49, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x48, 0x0a,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x04, 0x52, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x30, 0x0a, 0x14, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e,
	0x61, 0x6e, 0x6f, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x04, 0x52, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x73, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x22, 0x58, 0x0a,
	0x05, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x74, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x73, 0x74, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6e, 0x75,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6e, 0x75, 0x6d, 0x12, 0x19, 0x0a, 0x08,
	0x6e, 0x75, 0x6d, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07,
	0x6e, 0x75, 0x6d, 0x55, 0x6e, 0x69, 0x74, 0x22, 0xd5, 0x03, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a,
	0x66, 0x69, 0x6c, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x69,
	0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x66, 0x69,
	0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49,
	0x64, 0x12, 0x5c, 0x0a, 0x0d, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x5f, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x4b, 0x69,
	0x6e, 0x64, 0x52, 0x0b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x4b, 0x69, 0x6e, 0x64, 0x12,
	0x1e, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x04, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x68, 0x61, 0x73, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x68, 0x61, 0x73,
	0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x68, 0x61, 0x73,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x61, 0x73, 0x4c, 0x69, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x68, 0x61, 0x73, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x22,
	0xfc, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0c, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x45, 0x0a, 0x04, 0x6c,
	0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x09, 0x74, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1e,
	0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x04, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0x59,
	0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x12, 0x0a,
	0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x08, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x2a, 0x8c, 0x01, 0x0a, 0x16, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x27, 0x0a, 0x23, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x47,
	0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52,
	0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x4c, 0x54, 0x41, 0x10, 0x01, 0x12, 0x26, 0x0a,
	0x22, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d,
	0x50, 0x4f, 0x52, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x2a, 0x3c, 0x0a, 0x0b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x49, 0x44,
	0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x52, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x55, 0x49,
	0x4c, 0x44, 0x5f, 0x49, 0x44, 0x5f, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x53,
	0x48, 0x10, 0x01, 0x42, 0x6b, 0x5a, 0x3b, 0x67, 0x6f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x69, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x73, 0x6c, 0x69, 0x6d, 0x2f, 0x6f, 0x74, 0x6c, 0x70, 0x2f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0xaa, 0x02, 0x2b, 0x4f, 0x70, 0x65, 0x6e, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x2e, 0x56, 0x31, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescOnce sync.Once
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescData = file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDesc
)

func file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescGZIP() []byte {
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescOnce.Do(func() {
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescData = protoimpl.X.CompressGZIP(file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescData)
	})
	return file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDescData
}

var file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_goTypes = []interface{}{
	(AggregationTemporality)(0), // 0: opentelemetry.proto.profiles.v1experimental.AggregationTemporality
	(BuildIdKind)(0),            // 1: opentelemetry.proto.profiles.v1experimental.BuildIdKind
	(*Profile)(nil),             // 2: opentelemetry.proto.profiles.v1experimental.Profile
	(*AttributeUnit)(nil),       // 3: opentelemetry.proto.profiles.v1experimental.AttributeUnit
	(*Link)(nil),                // 4: opentelemetry.proto.profiles.v1experimental.Link
	(*ValueType)(nil),           // 5: opentelemetry.proto.profiles.v1experimental.ValueType
	(*Sample)(nil),              // 6: opentelemetry.proto.profiles.v1experimental.Sample
	(*Label)(nil),               // 7: opentelemetry.proto.profiles.v1experimental.Label
	(*Mapping)(nil),             // 8: opentelemetry.proto.profiles.v1experimental.Mapping
	(*Location)(nil),            // 9: opentelemetry.proto.profiles.v1experimental.Location
	(*Line)(nil),                // 10: opentelemetry.proto.profiles.v1experimental.Line
	(*Function)(nil),            // 11: opentelemetry.proto.profiles.v1experimental.Function
	(*v1.KeyValue)(nil),         // 12: opentelemetry.proto.common.v1.KeyValue
}
var file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_depIdxs = []int32{
	5,  // 0: opentelemetry.proto.profiles.v1experimental.Profile.sample_type:type_name -> opentelemetry.proto.profiles.v1experimental.ValueType
	6,  // 1: opentelemetry.proto.profiles.v1experimental.Profile.sample:type_name -> opentelemetry.proto.profiles.v1experimental.Sample
	8,  // 2: opentelemetry.proto.profiles.v1experimental.Profile.mapping:type_name -> opentelemetry.proto.profiles.v1experimental.Mapping
	9,  // 3: opentelemetry.proto.profiles.v1experimental.Profile.location:type_name -> opentelemetry.proto.profiles.v1experimental.Location
	11, // 4: opentelemetry.proto.profiles.v1experimental.Profile.function:type_name -> opentelemetry.proto.profiles.v1experimental.Function
	12, // 5: opentelemetry.proto.profiles.v1experimental.Profile.attribute_table:type_name -> opentelemetry.proto.common.v1.KeyValue
	3,  // 6: opentelemetry.proto.profiles.v1experimental.Profile.attribute_units:type_name -> opentelemetry.proto.profiles.v1experimental.AttributeUnit
	4,  // 7: opentelemetry.proto.profiles.v1experimental.Profile.link_table:type_name -> opentelemetry.proto.profiles.v1experimental.Link
	5,  // 8: opentelemetry.proto.profiles.v1experimental.Profile.period_type:type_name -> opentelemetry.proto.profiles.v1experimental.ValueType
	0,  // 9: opentelemetry.proto.profiles.v1experimental.ValueType.aggregation_temporality:type_name -> opentelemetry.proto.profiles.v1experimental.AggregationTemporality
	7,  // 10: opentelemetry.proto.profiles.v1experimental.Sample.label:type_name -> opentelemetry.proto.profiles.v1experimental.Label
	1,  // 11: opentelemetry.proto.profiles.v1experimental.Mapping.build_id_kind:type_name -> opentelemetry.proto.profiles.v1experimental.BuildIdKind
	10, // 12: opentelemetry.proto.profiles.v1experimental.Location.line:type_name -> opentelemetry.proto.profiles.v1experimental.Line
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_init() }
func file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_init() {
	if File_opentelemetry_proto_profiles_v1experimental_pprofextended_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Profile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeUnit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Sample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Label); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Mapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Line); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Function); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_goTypes,
		DependencyIndexes: file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_depIdxs,
		EnumInfos:         file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_enumTypes,
		MessageInfos:      file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_msgTypes,
	}.Build()
	File_opentelemetry_proto_profiles_v1experimental_pprofextended_proto = out.File
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_rawDesc = nil
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_goTypes = nil
	file_opentelemetry_proto_profiles_v1experimental_pprofextended_proto_depIdxs = nil
}
