/**
 * OWASP Enterprise Security API (ESAPI)
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * Enterprise Security API (ESAPI) project. For details, please see
 * <a href="http://www.owasp.org/index.php/ESAPI">http://www.owasp.org/index.php/ESAPI</a>.
 *
 * Copyright (c) 2009 - The OWASP Foundation
 * 
 * The ESAPI is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Arshan Dabirsiaghi <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @created 2009
 */
package org.owasp.esapi.waf;

import java.net.URL;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.owasp.esapi.http.MockFilterChain;
import org.owasp.esapi.http.MockHttpServletRequest;

import junit.framework.TestSuite;

public class BeanShellTest extends WAFTestCase {

	public static TestSuite suite() {
		return new TestSuite(BeanShellTest.class);
	}

	public void testRedirectBeanShellRule() throws Exception {

		request = new MockHttpServletRequest( new URL( "http://www.example.com/beanshelltest" ) );

    	WAFTestUtility.createAndExecuteWAFTransaction("waf-policies/bean-shell-policy.xml", request, response, new MockFilterChain() );
    	
    	HttpSession session = request.getSession();
    	
    	assert(session.getAttribute("simple_waf_test") != null);
    	assert(response.getStatus() == HttpServletResponse.SC_MOVED_PERMANENTLY);

	}

}
